	// Windows headers
#define _CRT_SECURE_NO_DEPRECATE
#include <windows.h>
#include <string>
using namespace std;
#include <time.h>
#include "iTunesVisualAPI.h"
#include <iostream>
#include <fstream>

#include <stdlib.h>

//#include "vcclr.h"

//	reporting things
bool gOK2Submit;	// flag to see if it's ok to send this track - set true on track change and false on track reposition
bool gPlaying;		//	 are we playing or not - don't want to feed back if stopped
bool gUpdateWarningDone;
std::wstring gStatusStringX; // just some temp debug info (even for the release build) 
std::wstring gErrStringX; // an error
DWORD gTrackStart; // the tick count when the track started, don't actually need to store?? check
DWORD gTargetReportTime; // the tick count when we need to report assuming all goes well.
///
std::wstring gArtist; // the current track info
std::wstring gTrack;
std::wstring gAlbum;
int gLen;
int gDelaySecs;
bool gRehandshake;
bool gEnabled;
ITTrackInfo *gTrackInfo;

std::ofstream gLogFile;
std::ofstream gXmlFile;

void Log(const std::string& msg)
{
	gLogFile << msg << std::endl;
}

void writeXML(const std::string& msg)
{
	gXmlFile << msg << std::endl;
}

std::string xmlCharReplace(const string& str, const std::string& sought, const std::string& rep)
{
	size_t pos;
	string nstr = str;

	pos = nstr.find(sought, 0);
	while (pos != string::npos) {
		nstr.erase(pos, 1);
		nstr.insert(pos, rep);
		pos = nstr.find(sought, pos + 1);
	}
	return nstr;
}

std::string xmlReplace(std::string& str)
{
	string nstr = str;

	nstr = xmlCharReplace(nstr, "&", "&amp;");
	nstr = xmlCharReplace(nstr, "'", "&apos;");
	nstr = xmlCharReplace(nstr, "\"", "&quot;");
	nstr = xmlCharReplace(nstr, "<", "&lt;");
	nstr = xmlCharReplace(nstr, ">", "&gt;");

	return nstr;
}
std::wstring fixStr(const std::wstring& str)
{
	std::wstring ret;

	if (str.length() == 0) return str;

	size_t len = (size_t)str[0];
	ret = str.substr(1);
	if(len > 0 && len < ret.length())
	{
		ret = ret.substr(0,len);
	}
	return ret;
}

void SetError(const std::wstring& err)
{
	gErrStringX = err;
}

void SetStatus(const std::wstring& stat)
{
	gStatusStringX = stat;
}

// Converts our nice unicode to utf-8 using
// MS' horrific api call :)
std::string toUTF(const std::wstring& wideStr)
{

	// first call works out required buffer length
	int recLen = WideCharToMultiByte(CP_UTF8,0,wideStr.c_str(),(int)wideStr.length(),NULL,NULL,NULL,NULL);

	char* buffer = new char[recLen + 1];
	memset(buffer,0,recLen+1);

	//	second call actaull converts
	WideCharToMultiByte(CP_UTF8,0,wideStr.c_str(),(int)wideStr.length(),buffer,recLen,NULL,NULL);

	std::string ret = buffer;

	delete[] buffer;

	return ret;


}

std::string ITStrToUTF(ITUniStr255 str)
{
	wstring nstr = (wchar_t*)str;
	string sstr = toUTF(fixStr(nstr));
	return xmlReplace(sstr);
}

//#define _DEBUG

//	submits the current song to audioscrobbler
static void AddSong()
{
	if(!gPlaying) 
   {
      Log("not playing in add song");
      return;
   }

	char buffer[33];
	time_t theTime;
	time(&theTime);
	string timestr;
	timestr = ctime(&theTime);
	// remove newline
	timestr.erase(24,1);
	//timestr[24] = '\0';
	writeXML("<song timestamp=\"" + timestr + "\">");
	writeXML("	<name>" + ITStrToUTF(gTrackInfo->name) + "</name>");
	writeXML("	<artist>" + ITStrToUTF(gTrackInfo->artist) + "</artist>");
	if (gTrackInfo->isCompilationTrack) {
		writeXML("	<compilation>1</compilation>");
	}
	writeXML("	<album>" + ITStrToUTF(gTrackInfo->album) + "</album>");
	writeXML("	<track>" + (string)_itoa(gTrackInfo->trackNumber,buffer,10) + "</track>");
	if (gTrackInfo->year > 0) {
		writeXML("	<year>" + (string)_itoa(gTrackInfo->year,buffer,10) + "</year>");
	}
	writeXML("	<time>" + (string)_itoa(gTrackInfo->totalTimeInMS,buffer,10) + "</time>");
	writeXML("</song>");
} 

/*
	VisualPluginHandler
*/
static OSStatus pluginMessageHandler (OSType message, VisualPluginMessageInfo *messageInfo, void *refCon)
{
	OSStatus			status;
	
	status = noErr;

	DWORD time = 0;

	switch (message)
	{
		/*
			Sent when the visual plugin is registered.  The plugin should do minimal
			memory allocations here.  The resource fork of the plugin is still available.
		*/		
		case kVisualPluginInitMessage:
		{
			break;
		}
			
		/*
			Sent when the visual plugin is unloaded
		*/		
		case kVisualPluginCleanupMessage:
			break;
			
		/*
			Sent when the visual plugin is enabled.  iTunes currently enables all
			loaded visual plugins.  The plugin should not do anything here.
		*/
		case kVisualPluginEnableMessage:
		case kVisualPluginDisableMessage:
			break;

		/*
			Sent if the plugin requests idle messages.  Do this by setting the kVisualWantsIdleMessages
			option in the PlayerRegisterVisualPluginMessage.options field.
		*/
		case kVisualPluginIdleMessage:
			//	we feedback in the idle handler, that way we work even if we 
			// are not visualizing or even the active plugin
			if(gOK2Submit && gPlaying && ::GetTickCount() > gTargetReportTime)
			{
				//	enough time has elapsed without the user intevening
				gOK2Submit = false;
				AddSong();
			}

			break;

		/*
			Sent if the plugin requests the ability for the user to configure it.  Do this by setting
			the kVisualWantsConfigure option in the PlayerRegisterVisualPluginMessage.options field.
		*/
		case kVisualPluginConfigureMessage:
		{
			break;
		}
		
		/*
			Sent when iTunes is going to show the visual plugin in a port.  At
			this point, the plugin should allocate any large buffers it needs.
		*/
		case kVisualPluginShowWindowMessage:
			break;
	
		/*
			Sent when iTunes is no longer displayed.
		*/
		case kVisualPluginHideWindowMessage:
			break;
		
		/*
			Sent when iTunes needs to change the port or rectangle of the currently
			displayed visual.
		*/
		case kVisualPluginSetWindowMessage:
			break;
		
		/*
			Sent for the visual plugin to render a frame.
		*/
		case kVisualPluginRenderMessage:
			break;
			
		/*
			Sent in response to an update event.  The visual plugin should update
			into its remembered port.  This will only be sent if the plugin has been
			previously given a ShowWindow message.
		*/	
		case kVisualPluginUpdateMessage:
			break;
		
		/*
			Sent when the player starts.
		*/
		case kVisualPluginPlayMessage:
			{
				Log("Play msg");

			std::wstring artist = (wchar_t*)messageInfo->u.playMessage.trackInfoUnicode->artist;
			std::wstring track  = (wchar_t*)messageInfo->u.playMessage.trackInfoUnicode->name;

			artist = fixStr(artist);
			track = fixStr(track);

			if(artist != gArtist || track != gTrack)
			{
				// track change
				Log("track change");
				gArtist  = artist;
				gTrack = track;
				gTrackInfo = messageInfo->u.playMessage.trackInfoUnicode;
				gAlbum  = (wchar_t*)messageInfo->u.playMessage.trackInfoUnicode->album;
				gLen = messageInfo->u.playMessage.trackInfoUnicode->totalTimeInMS / 1000;
     
				gAlbum = fixStr(gAlbum);

				std::wstring logstr = L"play " + artist + L"/" + track;
				//Log(logstr.c_str());

				if(gEnabled) 
					SetStatus(L"Playing");

				gPlaying = true;
				gOK2Submit = true;
				gTrackStart = ::GetTickCount();

				time =  messageInfo->u.playMessage.trackInfoUnicode->totalTimeInMS / 2;

				// target report time is 50% of track or 120 secs whichever comes first
				if((int)time > gDelaySecs * 1000)
				{
					gLogFile << "Using constant time delay: " << gDelaySecs << " seconds\n";
					time = gDelaySecs * 1000;
				}
				else
				{
					Log("Using 50% track time");
				}

#ifdef _DEBUG
				//	FOR FUCKS SAKE TAKE THIS OUT!!!!
				Log( "DANGER USING 5 SECS");
				time = 5000;
#endif

				// set when to report
				gTargetReportTime = gTrackStart + time;
			}


			break;

			}
		/*
			Sent when the player changes the current track information.  This
			is used when the information about a track changes, or when the CD
			moves onto the next track.  The visual plugin should update any displayed
			information about the currently playing song.
		*/
		case kVisualPluginChangeTrackMessage:
		{
			Log( "Track change msg");
			
			std::wstring artist = (wchar_t*)messageInfo->u.changeTrackMessage.trackInfoUnicode->artist;
			std::wstring track  = (wchar_t*)messageInfo->u.changeTrackMessage.trackInfoUnicode->name;

         	artist = fixStr(artist);
			track = fixStr(track);

			if(artist != gArtist || track != gTrack)
			{
				// track change
				Log("track change");
				gArtist  = artist;
				gTrack = track;
				gTrackInfo = messageInfo->u.changeTrackMessage.trackInfoUnicode;

				gAlbum  = (wchar_t*)messageInfo->u.changeTrackMessage.trackInfoUnicode->album;
				gLen = messageInfo->u.changeTrackMessage.trackInfoUnicode->totalTimeInMS / 1000;

				gAlbum = fixStr(gAlbum);

				std::wstring logstr = L"changing " + artist + L"/" + track;
				//Log(logstr.c_str());

				if(gEnabled)
					SetStatus(L"Playing");

				gPlaying = true;
				gOK2Submit = true;
				gTrackStart = ::GetTickCount();

				time =  messageInfo->u.changeTrackMessage.trackInfoUnicode->totalTimeInMS / 2;

				// target report time is 50% of track or 120 secs whichever comes first
				if((int)time > gDelaySecs * 1000)
				{
					gLogFile << "Using constant time delay: " << gDelaySecs << " seconds\n";
					time = gDelaySecs * 1000;
				}
				else
				{
					Log("Using 50% track time");
				}

#ifdef _DEBUG
				//	FOR FUCKS SAKE TAKE THIS OUT!!!!
				Log( "DANGER USING 5 SECS");
				time = 5000;
#endif

				// set when to report
				gTargetReportTime = gTrackStart + time;
			}

			}

			break;
		/*
			Sent when the player stops.
		*/
		case kVisualPluginStopMessage:

			
			Log( "stop msg");
			

			gPlaying = false;
			
			break;
		
		/*
			Sent when the player changes the track position.
		*/
		case kVisualPluginSetPositionMessage:

			
			Log( "setpos");
			
			gOK2Submit = false; // if the user repositions then we won't submit it

			break;

		/*
			Sent when the player pauses.  iTunes does not currently use pause or unpause.
			A pause in iTunes is handled by stopping and remembering the position.
		*/
		case kVisualPluginPauseMessage:
			
			Log( "pause");

			break;
			
		/*
			Sent when the player unpauses.  iTunes does not currently use pause or unpause.
			A pause in iTunes is handled by stopping and remembering the position.
		*/
		case kVisualPluginUnpauseMessage:

			
			Log( "unpause");
			
			gPlaying = true;

			break;
		
		/*
			Sent to the plugin in response to a MacOS event.  The plugin should return noErr
			for any event it handles completely, or an error (unimpErr) if iTunes should handle it.
		*/
		case kVisualPluginEventMessage:
			status = unimpErr;
			break;

		default:
			status = unimpErr;
			break;
	}

	return status;	
}


// register plugin with iTunes
OSStatus registerPlugin(PluginMessageInfo *messageInfo)
{
    // plugin constants
    const string pluginTitle = "AllPlays";
    const UInt8 pluginMajorVersion = 1;
    const UInt8 pluginMinorVersion = 0;
    const UInt32 pluginCreator = '\?\?\?\?';

    PlayerMessageInfo playerMessageInfo;
    memset(&playerMessageInfo.u.registerVisualPluginMessage, 0, sizeof(playerMessageInfo.u.registerVisualPluginMessage));

    // copy in name length byte first
    playerMessageInfo.u.registerVisualPluginMessage.name[0] = (UInt8)pluginTitle.length();

    // now copy in actual name
    memcpy(&playerMessageInfo.u.registerVisualPluginMessage.name[1], pluginTitle.c_str(), pluginTitle.length());

    SetNumVersion(&playerMessageInfo.u.registerVisualPluginMessage.pluginVersion, pluginMajorVersion, pluginMinorVersion, 0x80, 0);

    playerMessageInfo.u.registerVisualPluginMessage.options = kVisualWantsIdleMessages | kVisualWantsConfigure;
    playerMessageInfo.u.registerVisualPluginMessage.handler = pluginMessageHandler;
    playerMessageInfo.u.registerVisualPluginMessage.registerRefCon = 0;
    playerMessageInfo.u.registerVisualPluginMessage.creator = pluginCreator;

    playerMessageInfo.u.registerVisualPluginMessage.timeBetweenDataInMS = 0xFFFFFFFF; // 16 milliseconds = 1 Tick, 0xFFFFFFFF = Often as possible.
    playerMessageInfo.u.registerVisualPluginMessage.numWaveformChannels = 2;
    playerMessageInfo.u.registerVisualPluginMessage.numSpectrumChannels = 2;

    playerMessageInfo.u.registerVisualPluginMessage.minWidth = 64;
    playerMessageInfo.u.registerVisualPluginMessage.minHeight = 64;
    playerMessageInfo.u.registerVisualPluginMessage.maxWidth = 32767;
    playerMessageInfo.u.registerVisualPluginMessage.maxHeight = 32767;
    playerMessageInfo.u.registerVisualPluginMessage.minFullScreenBitDepth = 0;
    playerMessageInfo.u.registerVisualPluginMessage.maxFullScreenBitDepth = 0;
    playerMessageInfo.u.registerVisualPluginMessage.windowAlignmentInBytes = 0;

    OSStatus status = PlayerRegisterVisualPlugin(messageInfo->u.initMessage.appCookie, messageInfo->u.initMessage.appProc, &playerMessageInfo);

    return status;
}



/*
	MAIN

*/

extern "C" __declspec(dllexport) OSStatus iTunesPluginMain(OSType message, PluginMessageInfo *messageInfo, void *refCon)
{
    OSStatus status;

	int i;
	char iniPath[256];
	char logPath[256];
	char xmlPath[256];

    switch (message)
    {
        case kPluginInitMessage:
            status = registerPlugin(messageInfo);
		
			strncpy(iniPath, GetCommandLine(), strstr(GetCommandLine(), "\\iTunes.exe") - GetCommandLine() + 1);
			// removing the " at the begining of the command line
			if (strchr(iniPath, '"') != NULL)
				for(i = 0; i < (int)strlen(iniPath); i++)
					iniPath[i] = iniPath[i+1];
			strcpy(logPath, iniPath);
			strcat(iniPath, "Plug-Ins\\AllPlays.ini");
			strcat(logPath, "Plug-Ins\\AllPlaysLog.txt");
			GetPrivateProfileString("General", "xmlPath", "c:\\AllPlays.xml", xmlPath, 256, iniPath);
			gDelaySecs = GetPrivateProfileInt("General", "delay", 120, iniPath);

			gLogFile.open(logPath);
			gLogFile << "iTunes Started\n";
			gLogFile << "Looked for AllPlays.ini at " << iniPath << "\n";
			gLogFile << "Writing XML to " << xmlPath << "\n";

			gXmlFile.open(xmlPath, ios::app);
			break;

        case kPluginCleanupMessage:
            status = noErr;
			gLogFile.close();
 			gXmlFile.close();
            break;

        default:
            status = unimpErr;
            break;
    }

    return status;
}